<?php
/*******************************************************************************************\
|                                                                                           |
|   This file is part of the FX.php release from www.iviking.org and is released under the  |
|   artistic license (which is also included with the release.                              |
|                                                                                           |
|   The main purpose of these functions is to handle the secure output of image URLs from   |
|   FileMaker and the proxying of requests for these images.                                |
|                                                                                           |
|   For best security using these functions, before accessing images for the first time you |
|   should access the included echo_new_key.php file once; and paste the resulting key      |
|   within the quotes as the value of $encryt key in the "key section" below.  The key      |
|   inside the quotes should only be comprised of numbers and exclamation points (!).  Any  |
|   Other characters within the quotes should be removed.                                   |
|                                                                                           |
|   As a final note, please remember that it is possible to generate much higher security   |
|   measures within your individual solutions.  The use of sessions would be one way to do  |
|   this, but your individual needs may suggest other options.                              |
|                                                                                           |
|   -- Chris Hansen, creator of FX.php and VisualFX.php                                     |
|      email: FX@iviking.org                                                                |
|        web: www.iviking.org                                                               |
|                                                                                           |
\*******************************************************************************************/

// For best security with these functions, change this value as described above...
// Begin key section
$encryptKey = "66!121!174!252!120!104!252!185!191!249!98!186!129!102!99!51!118!249!135!45!241!240!134!75!224!40!195!133!235!57!66!245!97!102!180!164!55!229!213!173!227!229!69!230!250!76!149!253!129!82!207!52!140!241!73!202!150!252!43!85!69!52!50!66!123!161!59!57!74!110!169!166!175!81!233!243!239!157!226!73!69!161!237!174!105!121!108!75!118!78!196!143!232!255!244!149!181!206!74!232!146!223!191!71!41!170!135!53!45!191!182!144!235!83!87!157!93!165!201!128!88!191!60!77!175!222!151!124!128!190!125!125!50!244!232!233!129!38!215!243!239!171!222!39!126!217!113!245!101!242!50!95!194!113!128!98!51!139!191!196!144!60!55!139!69!137!101!136!118!229!67!144!112!116!186!113!90!189!239!93!245!150!134!173!67!94!60!67!77!126!45!183!95!166!144!173!157!180!41!52!116!105!208!44!177!136!124!119!103!158!47!169!67!221!138!176!130!130!70!86!251!76!225!197!161!198!79!98!243!122!214!233!218!210!81!228!61!180!80!38!121!61!145!104!130!40!155!79!170!93!53!178!86!40!118!211";
// End of key section

require_once('server_data.php');

$imageType = 'jpeg';
$forbiddenRequests = array('dbnames', 'delete', 'dup', 'edit', 'find', 'findall', 'findany', 'layoutnames', 'new', 'process', 'scriptnames', 'view');
$charArray = array(chr(37),chr(38),chr(39),chr(40),chr(41),chr(42),chr(43),chr(44),chr(45),chr(46),chr(47),chr(48),chr(49),chr(50),chr(51),chr(52),chr(53),chr(54),chr(55),chr(56),chr(57),chr(58),chr(59),chr(60),chr(61),chr(62),chr(63),chr(64),chr(65),chr(66),chr(67),chr(68),chr(69),chr(70),chr(71),chr(72),chr(73),chr(74),chr(75),chr(76),chr(77),chr(78),chr(79),chr(80),chr(81),chr(82),chr(83),chr(84),chr(85),chr(86),chr(87),chr(88),chr(89),chr(90),chr(91),chr(93),chr(94),chr(95),chr(96),chr(97),chr(98),chr(99),chr(100),chr(101),chr(102),chr(103),chr(104),chr(105),chr(106),chr(107),chr(108),chr(109),chr(110),chr(111),chr(112),chr(113),chr(114),chr(115),chr(116),chr(117),chr(118),chr(119),chr(120),chr(121),chr(122),chr(123),chr(124),chr(125),chr(126),chr(127),chr(128),chr(129),chr(130),chr(131),chr(132),chr(133),chr(134),chr(135),chr(136),chr(137),chr(138),chr(139),chr(140),chr(141),chr(142),chr(143),chr(144),chr(145),chr(146),chr(147),chr(148),chr(149),chr(150),chr(151),chr(152),chr(153),chr(154),chr(155),chr(156),chr(157),chr(158),chr(159),chr(160),chr(161),chr(162),chr(163),chr(164),chr(165),chr(166),chr(167),chr(168),chr(169),chr(170),chr(171),chr(172),chr(173),chr(174),chr(175),chr(176),chr(177),chr(178),chr(179),chr(180),chr(181),chr(182),chr(183),chr(184),chr(185),chr(186),chr(187),chr(188),chr(189),chr(190),chr(191),chr(192),chr(193),chr(194),chr(195),chr(196),chr(197),chr(198),chr(199),chr(200),chr(201),chr(202),chr(203),chr(204),chr(205),chr(206),chr(207),chr(208),chr(209),chr(210),chr(211),chr(212),chr(213),chr(214),chr(215),chr(216),chr(217),chr(218),chr(219),chr(220),chr(221),chr(222),chr(223),chr(224),chr(225),chr(226),chr(227),chr(228),chr(229),chr(230),chr(231),chr(232),chr(233),chr(234),chr(235),chr(236),chr(237),chr(238),chr(239),chr(240),chr(241),chr(242),chr(243),chr(244),chr(245),chr(246),chr(247),chr(248),chr(249),chr(250),chr(251),chr(252),chr(253),chr(254),chr(255));
$numChars = count($charArray);
$userPass = '';
if (! isset($_GET['FXuser'])) {
    $_GET['FXuser'] = '';
}
if (! isset($_GET['FXpass'])) {
    $_GET['FXpass'] = '';
}

function generateKey ($keyLength)
{
    $tempKey = '';
    $tempNum = 0;

    for ($i = 0; $i < $keyLength; ++$i) {
        if (strlen($tempKey) > 0) {
            $tempKey .= '!';
        }
        do {
            $tempNum = rand(37, 255);
        } while ($tempNum == 92);
        $tempKey .= $tempNum;
    }
    return $tempKey;
}

function vignereEncryptURL ($targetString)
{
    global $encryptKey, $charArray, $numChars;

    $keyArray = explode('!', $encryptKey);
    $targetArray = preg_split('//', $targetString, -1, PREG_SPLIT_NO_EMPTY);
    $encryptedURL = '';

    if (count($targetArray) > count($keyArray)) {
        while (count($targetArray) > count($keyArray)) {
            $keyArray = array_merge($keyArray, $keyArray);
        }
    }
    for ($i = 0; $i < count($targetArray); ++$i) {
        $encryptedURL .= $charArray[(($keyArray[$i] + array_search($targetArray[$i], $charArray)) % $numChars)];
    }
    $encryptedURL = urlencode($encryptedURL);
    return $encryptedURL;
}

function vignereDecryptURL ($targetString)
{
    global $encryptKey, $charArray, $numChars;

    $keyArray = explode('!', $encryptKey);
    $targetArray = preg_split('//', $targetString, -1, PREG_SPLIT_NO_EMPTY);
    $decryptedURL = '';

    if (count($targetArray) > count($keyArray)) {
        while (count($targetArray) > count($keyArray)) {
            $keyArray = array_merge($keyArray, $keyArray);
        }
    }
    for ($i = 0; $i < count($targetArray); ++$i) {
        $decryptedURL .= $charArray[((($numChars + array_search($targetArray[$i], $charArray)) - $keyArray[$i]) % $numChars)];
    }
    return $decryptedURL;
}

if (isset($_GET['FXimage'])) {
    str_replace($forbiddenRequests, '', $_GET['FXimage']);  // this lines keeps individuals from using this file to proxy most FM requests
    $currentURL = vignereDecryptURL($_GET['FXimage']);
    if (substr_count($currentURL, '.jpg') > 0) {
        $imageType = 'jpeg';
    } elseif (substr_count($currentURL, '.gif') > 0) {
        $imageType = 'gif';
    } elseif (substr_count($currentURL, '.tif') > 0) {
        $imageType = 'tiff';
    } elseif (substr_count($currentURL, '.png') > 0) {
        $imageType = 'png';
    }
    if (substr($currentURL, 0, 1) != '/') {
        $currentURL =  '/' . $currentURL;
    }
    if ($_GET['FXuser'] != '' || $_GET['FXpass'] != '') {
        $userPass = "{$_GET['FXuser']}:{$_GET['FXpass']}@";
    } else {
        $userPass = '';
    }
    $currentURL = "{$scheme}://{$userPass}{$serverIP}:{$webCompanionPort}{$currentURL}";
    header("Content-type: image/{$imageType}");
    @readfile($currentURL);
}
?>