<?php
/*
FX_charset by Masayuki Nii
Version 3.1 ( The version number is following the version of FX.php. )
Dec 29, 2004

Original source is FX.php #################################################
#																	   #
#	   By: Chris Hansen with Chris Adams, Gjermund Thorsen, and others #
#	 Date: 01 Aug 2004												 #
# Web Site: www.iviking.org											 #
#  Details: FX is a free open-source PHP class for accessing FileMaker  #
#		  data.  For complete details about this class, please visit   #
#		  www.iviking.org.											 #
#																	   #
#########################################################################
// Modified by Masayuki Nii ( msyk@msyk.net ) at Sept 1, 2004 in DevCon 2004.
// For searching the modified lines, find the word 'msyk'.
*/

//define('DEBUG', true);

require_once('FX/FX.php');

class FX_charset extends FX
{
	// Character Set variable ( by msyk - 2004/3/23 )
	var $charSet = 'utf8';	// Default character set is UTF-8
		// Zero length string means default (original) behavior using UTF8SpecialChars.
	var $dataParamsEncoding = 'utf8';	// Default character set is UTF-8
		// Zero length string means default (original) behavior.

	// Added by msyk - 2004/3/23 
	function SetCharacterEncoding($encoding)	{
		$this->charSet = $encoding;
		$this->dataParamsEncoding = $encoding;	// Modified by msyk 2004/9/4
			// You must call this 'SetCharacterEncoding' method before calling 'SetDataParamsEncoding'.
			// If you don't call 'SetDataParamsEncoding', two instance valiable is set the same value.
	}
	// Added by msyk - 2004/3/23 
	function SetDataParamsEncoding($encoding)	{
		$this->dataParamsEncoding = $encoding;
	}

	/*
	Overriding the following three methods for avoiding specialized character.
		StartElement, ElementContents, AddDBParam
	*/
	function StartElement($parser, $name, $attrs)	{
		if( ( strtolower($name) == 'field' ) && ( $this->charSet  != '' ) ) {
			foreach ($attrs as $key => $value) {
				$key = strtolower($key);
				$this->fieldInfo[$this->fieldCount][$key] 
					= mb_convert_encoding($value, $this->charSet, 'UTF-8');
			}
			$this->fieldInfo[$this->fieldCount]['extra'] = ''; // for compatibility w/ SQL databases
			if (substr_count($this->dataURL, '-view') < 1) {
				$this->fieldCount++;
			}
		}
		else
			parent::StartElement($parser, $name, $attrs);
	}

	function ElementContents($parser, $data)
	{
		if ( $this->dataParamsEncoding == '')
			parent::ElementContents($parser, $data);
		else	{
			switch($this->currentFlag) {
				case "parseData":
					$this->currentData[$this->currentRecord][$this->currentField][$this->currentFieldIndex] 
						.= mb_convert_encoding($data, $this->charSet, 'UTF-8');
					break;
				case "fmError":
					$this->fxError = $data;
					break;
				case "values":
					$this->valueLists[$this->currentValueList][$this->currentValueListElement] 
						.= mb_convert_encoding($data, $this->charSet, 'UTF-8');
					break;
			}
		}
	}

	function AddDBParam ($name, $value, $op="")	{
		if ( $this->dataParamsEncoding == '')
			parent::AddDBParam( $name, $value, $op );
		else	{
			$this->dataParams[]["name"] 
				= mb_convert_encoding($name, $this->dataParamsEncoding, $this->charSet);
			end($this->dataParams);
			$this->dataParams[key($this->dataParams)]["value"] 
				= mb_convert_encoding($value, $this->dataParamsEncoding, $this->charSet);
			$this->dataParams[key($this->dataParams)]["op"] = $op;
		}
	}
}
?>