<?php
#### FX.php #############################################################
#                                                                       #
#       By: Chris Hansen with Chris Adams, Gjermund Thorsen, and others #
#     Date: 2 March 2002                                                #
# Web Site: www.iviking.org                                             #
#  Details: FX is a free open-source PHP class for accessing FileMaker  #
#          data.  For complete details about this class, please visit   #
#          www.iviking.org.                                             #
#                                                                       #
#########################################################################
/* Modified by Masayuki Nii (2004/3/23), for Japanese language supporting. */

$emailErrorMessages = FALSE;                                            // Set this to TRUE to enable emailing of specific error messages.
$displayErrorMessage = TRUE;                                            // Set this to FALSE to display the $altErrorMessage to the user.
$webmasterEmailAddress = 'webmaster@yourdomain.com';                    // If you set the above to TRUE, enter the appropriate email address on this line.
$emailFromAddress = 'you@yourdomain.com';                               // Sets who the error message will show as the sender.

function EmailError ($errorText)
{
    global $webmasterEmailAddress;
    global $emailErrorMessages;
    global $emailFromAddress;
    if ($emailErrorMessages) {
        $emailSubject = "PHP Server Error";
        $emailMessage = "The following error just occured:\r\n\r\n$errorText\r\n\r\n**This is an automated message**";
        $emailStatus = mail($webmasterEmailAddress, $emailSubject, $emailMessage, "From: $emailFromAddress\r\n");
    }
}

function EmailErrorHandler ($errno, $errstr, $errfile, $errline)
{
    global $displayErrorMessage;
    $altErrorMessage = 'The Server was unable to process your request.<br />The WebMaster has been emailed.<br /> Thank you for your patience.';
    switch ($errno) {
        case E_USER_ERROR:
            $errorMessage = "<b>FATAL</b> [$errno] $errstr<br>\n";
            $errorMessage .= "  Fatal error in line " . $errline . " of file " . $errfile;
            $errorMessage .= ", PHP " . PHP_VERSION . " (" . PHP_OS . ")<br>\n";
            $errorMessage .= "Aborting...<br>\n";
            echo $errorMessage;
            exit -1;
            break;
        case E_USER_WARNING:
            $errorMessage = "<b>ERROR</b> [$errno] $errstr<br>\n";
            EmailError($errorMessage);
            echo $errorMessage;
            break;
        case E_USER_NOTICE:
            $errorMessage = "<b>WARNING</b> [$errno] $errstr<br>\n";
            EmailError($errorMessage);
            echo $errorMessage;
            break;
        default:
            $errorMessage = "Unkown error type: [$errno] $errstr<br>\n";
            EmailError($errorMessage);
            if ($displayErrorMessage) echo $errorMessage;
            else echo $altErrorMessage;
            break;
    }
}

class FX
{
    // These are the basic database variables.
    var $dataServer = "";
    var $dataServerType = 'FMPro5/6';
    var $dataPort;
    var $dataPortSuffix;
    var $database = "";
    var $layout = "";
    var $groupSize;
    var $currentSkip = 0;
    var $dataParams = array();
    var $sortParams = array();

    // These are the variables to be used for storing the retrieved data.
    var $fieldInfo = array();
    var $currentData = array();
    var $valueLists = array();
    var $totalRecordCount = -1;
    var $foundCount = -1;
    var $dateFormat = "";
    var $timeFormat = "";
    var $dataURL = "";
    var $dataURLParams = "";

    // Flags and Error Tracking
    var $currentFlag = '';
    var $currentRecord = '';
    var $currentField = '';
    var $currentValueList = '';
    var $fieldCount = 0;
    var $columnCount = -1;                                                // columnCount is ++ed BEFORE looping
    var $fxError = 'No Action Taken';
    var $errorTracking = 0;

    // These variables will be used if you need a password to access your FileMaker data.
    var $DBUser = 'FX';
    var $DBPassword = '';                                                 // This can be left blank, or replaced with a default or dummy password.
    var $userPass = '';

    // These variables are related to sending data to FileMaker via a Post.
    var $isPostQuery = true;
    var $useCURL = true;

    // Other variables
    var $invalidXMLChars = array("\x0B", "\x0C");
    
    // Character Set variable ( by msyk - 2004/3/23 )
    var $charSet = '';          // Zero length string means default (original) behavior using UTF8SpecialChars.
    var $dataParamsEncoding = '';     // Zero length string means default (original) behavior.

    /*
        Translation arrays used with str_replace to handle special
        characters in UTF-8 data received from FileMaker. The two arrays
        should have matching numeric indexes such that $UTF8SpecialChars[0]
        contains the raw binary equivalent of $UTF8HTMLEntities[0].

        This would be a perfect use for strtr(), except that it only works
        with single-byte data. Instead, we use preg_replace, which means
        that we need to delimit our match strings

        Please note that in this latest release I've removed the need for
        the include files which contained long lists of characters. Gjermund
        was sure there was a better way and he was right. With the two six
        element arrays below, every unicode character is allowed for. Let
        me know how this works for you. A link to Gjermund's homepage can
        be found in the FX Links section of www.iViking.org.
     */
    var $UTF8SpecialChars = array(
        "|([\xC2-\xDF])([\x80-\xBF])|e",
        "|(\xE0)([\xA0-\xBF])([\x80-\xBF])|e",
        "|([\xE1-\xEF])([\x80-\xBF])([\x80-\xBF])|e",
        "|(\xF0)([\x90-\xBF])([\x80-\xBF])([\x80-\xBF])|e",
        "|([\xF1-\xF3])([\x80-\xBF])([\x80-\xBF])([\x80-\xBF])|e",
        "|(\xF4)([\x80-\x8F])([\x80-\xBF])([\x80-\xBF])|e"
    );

    var $UTF8HTMLEntities = array(
        "\$this->BuildExtendedChar('\\1','\\2')",
        "\$this->BuildExtendedChar('\\1','\\2','\\3')",
        "\$this->BuildExtendedChar('\\1','\\2','\\3')",
        "\$this->BuildExtendedChar('\\1','\\2','\\3','\\4')",
        "\$this->BuildExtendedChar('\\1','\\2','\\3','\\4')",
        "\$this->BuildExtendedChar('\\1','\\2','\\3','\\4')"
    );

    function BuildExtendedChar ($byteOne, $byteTwo="\x00", $byteThree="\x00", $byteFour="\x00")
    {
        if (ord($byteTwo) >= 128) {
            $tempChar = substr(decbin(ord($byteTwo)), -6);
            if (ord($byteThree) >= 128) {
                $tempChar .= substr(decbin(ord($byteThree)), -6);
                if (ord($byteFour) >= 128) {
                    $tempChar .= substr(decbin(ord($byteFour)), -6);
                    $tempChar = substr(decbin(ord($byteOne)), -3) . $tempChar;
                } else {
                    $tempChar = substr(decbin(ord($byteOne)), -4) . $tempChar;
                }
            } else {
                $tempChar = substr(decbin(ord($byteOne)), -5) . $tempChar;
            }
        } else $tempChar = $byteOne;
        $tempChar = '&#' . bindec($tempChar) . ';';
        return $tempChar;
    }

    function ClearAllParams ()
    {
        $this->userPass = "";
        $this->dataURL = "";
        $this->dataURLParams = "";
        $this->dataParams = array();
        $this->sortParams = array();
        $this->fieldInfo = array();
        $this->valueLists = array();
        $this->fieldCount = 0;
        $this->currentSkip = 0;
        $this->currentData = array();
        $this->columnCount = -1;
        $this->currentRecord = "";
        $this->currentField = "";
        $this->currentFlag = "";
        $this->isPostQuery = true;
    }

    function ErrorHandler ($errorText)
    {
        $this->fxError = $errorText;
        $this->errorTracking = 3300;
        return $errorText;
    }

    function FX ($dataServer, $dataPort=591)
    {
        $this->dataServer = $dataServer;
        $this->dataPort = $dataPort;
        $this->dataPortSuffix = ":" . $dataPort;

        $this->ClearAllParams();
    }

    function CreateCurrentSort ()
    {
        $currentSort = "";

        foreach ($this->sortParams as $key1 => $value1) {
            foreach ($value1 as $key2 => $value2) {
                $$key2 = $value2;
            }
            if ($sortOrder == "") {
                $currentSort .= "&-sortfield=" . str_replace ("%3A%3A", "::", rawurlencode($field));
            }
            else {
                $currentSort .= "&-sortfield=" . str_replace ("%3A%3A", "::", rawurlencode($field)) . "&-sortorder=" . $sortOrder;
            }
        }
        return $currentSort;
    }

    function CreateCurrentSearch ()
    {
        $currentSearch = '';

        foreach ($this->dataParams as $key1 => $value1) {
            foreach ($value1 as $key2 => $value2) {
                $$key2 = $value2;
            }
            if ($op == "") {
                $currentSearch .= "&" . str_replace ("%3A%3A", "::", urlencode($name)) . "=" . urlencode($value);
            }
            else {
                $currentSearch .= "&-op=" . $op . "&" . str_replace ("%3A%3A", "::", urlencode($name)) . "=" . urlencode($value);
            }
        }
        return $currentSearch;
    }

    function AssembleCurrentSearch ($layRequest, $skipRequest, $currentSort, $currentSearch, $action)
    {
        $tempSearch = '';

        $tempSearch = "-db=" . urlencode($this->database);               // add the name of the database...
        $tempSearch .= $layRequest;                                      // and any layout specified...
        $tempSearch .= "&-format=-fmp_xml";                              // then set the FileMaker XML format to use...
        $tempSearch .= "&-max=$this->groupSize$skipRequest";             // add the set size and skip size data...
        $tempSearch .= $currentSort . $currentSearch . "&" . $action;    // finally, add sorting, search parameters, and action data.
        return $tempSearch;
    }

    function StartElement($parser, $name, $attrs)                        // The functions to start XML parsing begin here
    {
        switch(strtolower($name)) {
             case "data":
                $this->currentFlag = "parseData";
                $this->currentData[$this->currentRecord][$this->currentField][$this->currentFieldIndex] = "";
                break;
            case "col":
                $this->currentFieldIndex = 0;
                ++$this->columnCount;
                $this->currentField = $this->fieldInfo[$this->columnCount]['name'];
                $this->currentData[$this->currentRecord][$this->currentField] = array();
                break;
            case "row":
                foreach ($attrs as $key => $value) {
                    $key = strtolower($key);
                    $$key = $value;
                }
                if (substr_count($this->dataURL, '-dbnames') > 0 || substr_count($this->dataURL, '-layoutnames') > 0) {
                    $modid = count($this->currentData);
                }
                $this->currentRecord = $recordid . '.' . $modid;
                $this->currentData[$this->currentRecord] = array();
                break;
            case "field":
                foreach ($attrs as $key => $value) {
                    $key = strtolower($key);
                    $this->fieldInfo[$this->fieldCount][$key] = $value;
                }
                if (substr_count($this->dataURL, '-view') < 1) {
                    $this->fieldCount++;
                }
                break;
            case "style":
                foreach ($attrs as $key => $value) {
                    $key = strtolower($key);
                    $this->fieldInfo[$this->fieldCount][$key] = $value;
                }
                break;
            case "resultset":
                foreach ($attrs as $key => $value) {
                    switch(strtolower($key)) {
                        case "found":
                          $this->foundCount = (int)$value;
                          break;
                    }
                }
                break;
            case "errorcode":
                $this->currentFlag = "fmError";
                break;
            case "valuelist":
                foreach ($attrs as $key => $value) {
                    if (strtolower($key) == "name") {
                        $this->currentValueList = $value;
                    }
                }
                $this->valueLists[$this->currentValueList] = array();
                $this->currentFlag = "values";
                $this->currentValueListElement = -1;
                break;
            case "value":
                $this->currentValueListElement++;
                $this->valueLists[$this->currentValueList][$this->currentValueListElement] = "";
                break;
            case "database":
                foreach ($attrs as $key => $value) {
                    switch(strtolower($key)) {
                        case "dateformat":
                          $this->dateFormat = $value;
                          break;
                        case "records":
                          $this->totalRecordCount = $value;
                          break;
                        case "timeformat":
                          $this->timeFormat = $value;
                          break;
                    }
                }
                break;
            default:
                break;
        }
    }

          // Added by msyk - 2004/3/23 
    function SetCharacterEncoding($encoding)	{
        $this->charSet = $encoding;
    }

          // Added by msyk - 2004/3/23 
    function SetDataParamsEncoding($encoding)	{
        $this->dataParamsEncoding = $encoding;
    }

          // Affect the charSet variable. ( Modified by msyk - 2004/3/23 )
    function ElementContents($parser, $data)
    {
        switch($this->currentFlag) {
            case "parseData":
                if ( $this->charSet  == '' )
                    $this->currentData[$this->currentRecord][$this->currentField][$this->currentFieldIndex] .= preg_replace($this->UTF8SpecialChars, $this->UTF8HTMLEntities, $data);
                else
                    $this->currentData[$this->currentRecord][$this->currentField][$this->currentFieldIndex] .= mb_convert_encoding($data, $this->charSet, 'UTF-8');
                break;
            case "fmError":
                $this->fxError = $data;
                break;
            case "values":
                if ( $this->$charSet  == '' )
                    $this->valueLists[$this->currentValueList][$this->currentValueListElement] .= preg_replace($this->UTF8SpecialChars, $this->UTF8HTMLEntities, $data);
                else
                    $this->valueLists[$this->currentValueList][$this->currentValueListElement] .= mb_convert_encoding($data, $this->charSet, 'UTF-8');
                break;
        }
    }

    function EndElement($parser, $name)
    {
        switch(strtolower($name)) {
            case "data":
                $this->currentFieldIndex++;
                $this->currentFlag = "";
                break;
            case "col":
                break;
            case "row":
                $this->columnCount = -1;
                break;
            case "field":
                if (substr_count($this->dataURL, '-view') > 0) {
                    $this->fieldCount++;
                }
                break;
            case "errorcode":
            case "valuelist":
                $this->currentFlag = "";
                break;
        }
    }                                                                     // XML Parsing Functions End Here

    function RetrieveFMData ($action)
    {
        $data = '';
        if ($this->DBPassword != '') {                                      // Assemple the Password Data
            $this->userPass = $this->DBUser . ':' . $this->DBPassword . '@';
        }
        if ($this->layout != "") {                                          // Set up the layout portion of the query.
            $layRequest = "&-lay=" . urlencode($this->layout);
        }
        else {
            $layRequest = "";
        }
        if ($this->currentSkip > 0) {                                       // Set up the skip size portion of the query.
            $skipRequest = "&-skip=$this->currentSkip";
        } else {
            $skipRequest = "";
        }
        $currentSort = $this->CreateCurrentSort();
        $currentSearch = $this->CreateCurrentSearch();
        $this->dataURL = "http://$this->userPass$this->dataServer$this->dataPortSuffix/FMPro"; // First add the server info to the URL...
        $this->dataURLParams = $this->AssembleCurrentSearch($layRequest, $skipRequest, $currentSort, $currentSearch, $action);
        $this->dataURL .= '?' . $this->dataURLParams;

        if (defined("DEBUG") and DEBUG) {
            echo "<P>Using FileMaker URL: <a href=\"{$this->dataURL}\">{$this->dataURL}</a><P>\n";
        }

        if (defined("HAS_PHPCACHE") and defined("FX_USE_PHPCACHE") and strlen($this->dataURLParams) <= 510 and (substr_count($this->dataURLParams, '-find') > 0 || substr_count($this->dataURLParams, '-view') > 0 || substr_count($this->dataURLParams, '-dbnames') > 0 || substr_count($this->dataURLParams, '-layoutnames') > 0)) {
            $data = get_url_cached($this->dataURL, $this->dataURLParams) or die($this->ErrorHandler("could not open XML input"));
            if (!xml_parse($xml_parser, $data["Body"], true)) {
                die($this->ErrorHandler(sprintf("XML error: %s at line %d",
                    xml_error_string(xml_get_error_code($xml_parser)),
                    xml_get_current_line_number($xml_parser))));
            }
        } elseif ($this->isPostQuery) {
            if ($this->useCURL && defined("CURLOPT_TIMEVALUE")) {
                $curlHandle = curl_init($this->dataURL);
                curl_setopt($curlHandle, CURLOPT_POST, 1);
                curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $this->dataURLParams);
                set_error_handler("EmailErrorHandler");
                ob_start();
                if (!curl_exec($curlHandle)) {
                    die($this->ErrorHandler("could not open XML input"));
                }
                curl_close($curlHandle);
                $data = trim(ob_get_contents());
                ob_end_clean();
                if (substr($data, -1) != '>') {
                    $data = substr($data, 0, -1);
                }
            } else {
                $dataDelimiter = "\r\n";
                $socketData = "POST /FMPro HTTP/1.0{$dataDelimiter}";
                if (strlen(trim($this->userPass)) > 1) {
                    $socketData .= "Authorization: Basic " . base64_encode($this->DBUser . ':' . $this->DBPassword) . $dataDelimiter;
                }
                $socketData .= "Host: {$this->dataServer}:{$this->dataPort}{$dataDelimiter}";
                $socketData .= "Pragma: no-cache{$dataDelimiter}";
                $socketData .= "Content-length: " . strlen($this->dataURLParams) . $dataDelimiter;
                $socketData .= "Content-type: application/x-www-form-urlencoded{$dataDelimiter}";
                // $socketData .= "Connection: close{$dataDelimiter}";
                $socketData .= $dataDelimiter . $this->dataURLParams;

                set_error_handler("EmailErrorHandler");
                $fp = fsockopen ($this->dataServer, $this->dataPort, $this->errorTracking, $this->fxError, 30) or die($this->ErrorHandler("could not open XML input"));
                restore_error_handler();
                fputs ($fp, $socketData);
                while (!feof($fp)) {
                    $data .= fgets($fp, 128);
                }
                fclose($fp);
                $pos = strpos($data, chr(13) . chr(10) . chr(13) . chr(10)); // the separation code
                $data = substr($data, $pos + 4) . "\r\n";
            }
        } else {
            set_error_handler("EmailErrorHandler");
            $fp = fopen($this->dataURL, "r") or die($this->ErrorHandler("could not open XML input"));
            restore_error_handler();
            while (!feof($fp)) {
                $data .= fread($fp, 4096);
            }
            fclose($fp);
        }
        $data = str_replace($this->invalidXMLChars, '', $data);
        return $data;
    }

    function ExecuteQuery ($action)
    {
        switch ($this->dataServerType) {
            case 'FMPro5/6':
                if (defined("DEBUG") and DEBUG) {
                    echo "<P>Accessing FileMaker Pro data.<P>\n";
                }
                $data = $this->RetrieveFMData($action);

                $xml_parser = xml_parser_create("UTF-8");
                xml_set_object($xml_parser, &$this);
                xml_set_element_handler($xml_parser, "StartElement", "EndElement");
                xml_set_character_data_handler($xml_parser, "ElementContents");
                if (!xml_parse($xml_parser, $data, true)) {
                    die($this->ErrorHandler(sprintf("XML error: %s at line %d",
                        xml_error_string(xml_get_error_code($xml_parser)),
                        xml_get_current_line_number($xml_parser))));
                }
                xml_parser_free($xml_parser);
                break;
        }
    }

    function SetDBData ($database, $layout="", $groupSize=50)
    {
        $this->database = $database;
        $this->layout = $layout;
        $this->groupSize = $groupSize;
        $this->ClearAllParams();
    }

    function SetDBPassword ($DBPassword, $DBUser='FX')
    {
        if ($DBUser == '') {
            $DBUser = 'FX';
        }
        $this->DBPassword = $DBPassword;
        $this->DBUser = $DBUser;
    }

        // Modified by msyk 2004/3/23
    function AddDBParam ($name, $value, $op="")                          // Add a search parameter.  An operator is usually not necessary.
    {
        if ( $this->dataParamsEncoding == '')
            $this->dataParams[]["name"] = $name;
        else
            $this->dataParams[]["name"] = mb_convert_encoding($name, $this->dataParamsEncoding, $this->charSet);
        end($this->dataParams);
        if ( $this->dataParamsEncoding == '')
            $this->dataParams[key($this->dataParams)]["value"] = $value;
        else
            $this->dataParams[key($this->dataParams)]["value"] = mb_convert_encoding($value, $this->dataParamsEncoding, $this->charSet);
        $this->dataParams[key($this->dataParams)]["op"] = $op;
    }

    function AddSortParam ($field, $sortOrder="")                        // Add a sort parameter.  An operator is usually not necessary.
    {
        $this->sortParams[]["field"] = $field;
        end($this->sortParams);
        $this->sortParams[key($this->sortParams)]["sortOrder"] = $sortOrder;
    }

    function AssembleDataSet ($returnData)
    {
        global $HTTP_SERVER_VARS;
        global $HTTP_POST_VARS;
        $dataSet = array();
        $FMNext = $this->currentSkip + $this->groupSize;
        $FMPrevious = $this->currentSkip - $this->groupSize;

        switch ($returnData) {
            case 'full':
                $dataSet['data'] = $this->currentData;
            case 'basic':
                if ($FMNext < $this->foundCount || $FMPrevious >= 0) {              // BEGIN PARAMETER ASSEMBLY FOR NEXT/PREV LINKS
                    $tempQueryString = '';
                    if ($HTTP_SERVER_VARS['REQUEST_METHOD'] == 'POST') {
                        $paramSetCount = 0;
                        $appendFlag = true;
                        foreach ($HTTP_POST_VARS as $key => $value) {
                            if ($appendFlag && strcasecmp($key, '-foundSetParams_begin') != 0 && strcasecmp($key, '-foundSetParams_end') != 0) {
                                $tempQueryString .= urlencode($key) . '=' . urlencode($value) . '&';
                            } elseif (strcasecmp($key, '-foundSetParams_begin') == 0) {
                                $appendFlag = true;
                                if ($paramSetCount < 1) {
                                    $tempQueryString = '';
                                    ++$paramSetCount;
                                }
                            } elseif (strcasecmp($key, '-foundSetParams_end') == 0) {
                                $appendFlag = false;
                            }
                        }
                    } else {
                        $beginTagLower = strtolower('-foundSetParams_begin');
                        $endTagLower = strtolower('-foundSetParams_end');
                        if (! isset($HTTP_SERVER_VARS['QUERY_STRING'])) {
                            $HTTP_SERVER_VARS['QUERY_STRING'] = '';
                        }
                        $queryStringLower = strtolower($HTTP_SERVER_VARS['QUERY_STRING']);
                        if (substr_count($queryStringLower, $beginTagLower) > 0 && substr_count($queryStringLower, $beginTagLower) == substr_count($queryStringLower, $endTagLower)) {
                            $tempOffset = 0;
                            for ($i = 0; $i < substr_count($queryStringLower, $beginTagLower); ++$i) {
                                $tempBeginFoundSetParams = strpos($queryStringLower, $beginTagLower, $tempOffset);
                                $tempEndFoundSetParams = strpos($queryStringLower, $endTagLower, $tempOffset) + (strlen($endTagLower) - 1);
                                $tempFoundSetParams = substr($HTTP_SERVER_VARS['QUERY_STRING'], $tempBeginFoundSetParams, ($tempEndFoundSetParams - $tempBeginFoundSetParams) + 1);
                                $tempQueryString .= preg_replace("/(?i)$beginTagLower=[^&]*&(.*)&$endTagLower/", "\$1", $tempFoundSetParams);
                                $tempOffset = $tempEndFoundSetParams;
                            }
                        } else {
                            $tempQueryString = $HTTP_SERVER_VARS['QUERY_STRING'];
                        }
                        $tempQueryString = preg_replace("/skip=[\d]*[&]?/", "", $tempQueryString);
                    }
                }                                                                   // END PARAMETER ASSEMBLY FOR NEXT/PREV LINKS
                if ($FMNext >= $this->foundCount) {
                    $dataSet['linkNext'] = "";
                } else {
                    $dataSet['linkNext'] = $HTTP_SERVER_VARS['SCRIPT_NAME'] . "?skip=$FMNext&{$tempQueryString}";
                }

                if ($FMPrevious < 0) {
                    $dataSet['linkPrevious'] = "";
                } else {
                    $dataSet['linkPrevious'] = $HTTP_SERVER_VARS['SCRIPT_NAME'] . "?skip=$FMPrevious&{$tempQueryString}";
                }

                $dataSet['foundCount'] = $this->foundCount;
                $dataSet['fields'] = $this->fieldInfo;
                $dataSet['URL'] = $this->dataURL;
                $dataSet['errorCode'] = $this->fxError;
                $dataSet['valueLists'] = $this->valueLists;
        }

        $this->ClearAllParams();
        return $dataSet;
    }

    function FMAction ($Action, $returnDataSet, $returnData)
    {
        $this->ExecuteQuery($Action);
        if ($returnDataSet) {
            $dataSet = $this->AssembleDataSet($returnData);
            return $dataSet;
        } else {
            $this->ClearAllParams();
            return true;
        }
    }

/* The actions that you can send to FileMaker start here */

    function FMDBOpen ()
    {
        $this->ExecuteQuery("-dbopen");
    }

    function FMDBClose ()
    {
        $this->ExecuteQuery("-dbclose");
    }

    function FMSkipRecords ($skipSize)
    {
        $this->currentSkip = $skipSize;
    }

    function FMPostQuery ($isPostQuery = true)
    {
        $this->isPostQuery = $isPostQuery;
    }

    function FMUseCURL ($useCURL = true)
    {
        $this->useCURL = $useCURL;
    }

    function FMDelete ($returnDataSet = false, $returnData = 'basic')
    {
        return $this->FMAction("-delete", $returnDataSet, $returnData);
    }

    function FMEdit ($returnDataSet = true, $returnData = 'full')
    {
        return $this->FMAction("-edit", $returnDataSet, $returnData);
    }

    function FMFind ($returnDataSet = true, $returnData = 'full')
    {
        return $this->FMAction("-find", $returnDataSet, $returnData);
    }

    function FMFindAll ($returnDataSet = true, $returnData = 'full')
    {
        return $this->FMAction("-findall", $returnDataSet, $returnData);
    }

    function FMFindAny ($returnDataSet = true, $returnData = 'full')
    {
        return $this->FMAction("-findany", $returnDataSet, $returnData);
    }

    function FMNew ($returnDataSet = true, $returnData = 'full')
    {
        return $this->FMAction("-new", $returnDataSet, $returnData);
    }

    function FMView ($returnDataSet = true, $returnData = 'full')
    {
        return $this->FMAction("-view", $returnDataSet, $returnData);
    }

    function FMDBNames ($returnDataSet = true, $returnData = 'full')
    {
        return $this->FMAction("-dbnames", $returnDataSet, $returnData);
    }

    function FMLayoutNames ($returnDataSet = true, $returnData = 'full')
    {
        return $this->FMAction("-layoutnames", $returnDataSet, $returnData);
    }

}
?>