<?php
###########OME.php/The character set of this file is EUC-JP################
#
#  OME( Open Mail Envrionment ) for PHP   http://mac-ome.jp
#  by Masayuki Nii ( msyk@msyk.net )
#
#  Υ饹ϡܸǤ᡼Ԥ˺äΤǤ

class OME	{

var $body='';
var $subject='';
var $toField='';
var $ccField='';
var $bccField='';
var $fromField='';
var $extHeaders='';
var $errorMessage='';
var $sendmailParam='';

/*	顼å롣顼åEUCܸ졣
	Υ饹¿δؿϡͤbooleanȤʤäƤơȤ˥顼ɤȽ̤롣
	falseǤ硢δؿȤäƥ顼åǤ롣
*/
function getErrorMessage()	{
	return $this->errorMessage;
}

/*	᡼ʸꤹ롣¸ʸ֤롣
*/
function setBody($str)	{
	$this->body = $str;	return true;
}

/*	᡼ʸɲä롣¸ʸθɲä
*/
function appendBody($str)	{
	$this->body .= $str;	return true;
}

/*	᡼η̾ꤹ롣
*/
function setSubject($str)	{
	$this->subject = $str;	return true;
}

/*	ɲäΥإåꤹ롣

	ñɲäΤǡŪˤFromϴޤޤʤȤ롣
	ʣΥإåϡ\nǶڤäɲä롣
	󥳡ǥϹԤ鷺ΤޤΤǡܸޤʤ
	Ǥϡʬǥ󥳡ɤ򤹤ɬפ롣
*/
function setExtraHeader($field, $value)	{
	$this->extHeaders = "$fields: $value\n";	return true;
}

/*	᡼륢ɥ쥹ɤȽǤ	*/
function checkEmail($address)	{
	if( ! eregi ("^([a-z0-9_]|\\-|\\.)+@(([a-z0-9_]|\\-)+\\.)+[a-z]+$", $address) )	{
		$this->errorMessage = "ɥ쥹#addressɤʤ᡼륢ɥ쥹Ǥ";
		return false;
	} else {
		return true;
	}
}

/*	Fromեɤꤹ롣
	$address: ԤΥɥ쥹
	$name: ܸ̾ʤɤEUC-JPǤФΤޤ޻ǽ
*/
function setFromField($address, $name='')	{
	if ( $this->checkEmail($address) )	{
		if ( $name == '' )	{
			$this->fromField = $address;
			$this->sendmailParam = "-f$address";
		}
		else	{
			$this->fromField = "$name <$address>";
			$this->sendmailParam = "-f$address";
		}
		return true;
	}
	return false;
}

/*	Toեɤꤹ롣ǤꤵƤо񤭤졢ΰĤ
	$address: ԤΥɥ쥹
	$name: ܸ̾ʤɤEUC-JPǤФΤޤ޻ǽ
	: ᡼륢ɥ쥹Ĵ٤ʤfalseʥɥ쥹ꤵʤˡǤʤtrue
*/
function setToField($address, $name='')	{
	if ( $this->checkEmail($address) )	{
		if ( $name == '' )
			$this->toField = "$address";
		else
			$this->toField = "$name <$address>";
		return true;
	}
	return false;
}

/*	Toեɤɲä롣
	$address: ԤΥɥ쥹
	$name: ܸ̾ʤɤEUC-JPǤФΤޤ޻ǽ
	: ᡼륢ɥ쥹Ĵ٤ʤfalseʥɥ쥹ɲäʤˡǤʤtrue
*/
function appendToField($address, $name='')	{
	if ( $this->checkEmail($address) )	{
		if ( $name == '' )
			$appendString = "$address";
		else
			$appendString = "$name <$address>";
		if ( $this->toField == '' )
			$this->toField = $appendString;
		else
			$this->toField .= ", $appendString";
		return true;
	}
	return false;
}

/*	Ccեɤꤹ롣ǤꤵƤо񤭤졢ΰĤ
	$address: ԤΥɥ쥹
	$name: ܸ̾ʤɤEUC-JPǤФΤޤ޻ǽ
	: ᡼륢ɥ쥹Ĵ٤ʤfalseʥɥ쥹ꤵʤˡǤʤtrue
*/
function setCcField($address, $name='')	{
	if ( $this->checkEmail($address) )	{
		if ( $name == '' )
			$this->ccField = "$address";
		else
			$this->ccField = "$name <$address>";
		return true;
	}
	return false;
}

/*	Ccեɤɲä롣
	$address: ԤΥɥ쥹
	$name: ܸ̾ʤɤEUC-JPǤФΤޤ޻ǽ
	: ᡼륢ɥ쥹Ĵ٤ʤfalseʥɥ쥹ɲäʤˡǤʤtrue
*/
function appendCcField($address, $name='')	{
	if ( $this->checkEmail($address) )	{
		if ( $name == '' )
			$appendString = "$address";
		else
			$appendString = "$name <$address>";
		if ( $this->ccField == '' )
			$this->ccField = $appendString;
		else
			$this->ccField .= ", $appendString";
		return true;
	}
	return false;
}

/*	Bccեɤꤹ롣ǤꤵƤо񤭤졢ΰĤ
	$address: ԤΥɥ쥹
	$name: ܸ̾ʤɤEUC-JPǤФΤޤ޻ǽ
	: ᡼륢ɥ쥹Ĵ٤ʤfalseʥɥ쥹ꤵʤˡǤʤtrue
*/
function setBccField($address, $name='')	{
	if ( $this->checkEmail($address) )	{
		if ( $name == '' )
			$this->bccField = "$address";
		else
			$this->bccField = "$name <$address>";
		return true;
	}
	return false;
}

/*	Bccեɤɲä롣
	$address: ԤΥɥ쥹
	$name: ܸ̾ʤɤEUC-JPǤФΤޤ޻ǽ
	: ᡼륢ɥ쥹Ĵ٤ʤfalseʥɥ쥹ɲäʤˡǤʤtrue
*/
function appendBccField($address, $name='')	{
	if ( $this->checkEmail($address) )	{
		if ( $name == '' )
			$appendString = "$address";
		else
			$appendString = "$name <$address>";
		if ( $this->bccField == '' )
			$this->bccField = $appendString;
		else
			$this->bccField .= ", $appendString";
		return true;
	}
	return false;
}

var $tmpContents = '';

/*	ꤷեƥץ졼ȤȤɤ߹ࡣ
	ȤСƱΥǥ쥯ȥˤեʤ顢ե̾򵭽ҤФ褤
	顼װե뤬ʤ
*/
function setTemplateAsFile($tfile)	{
	$fileContensArray = file( $tfile );
	if ( $fileContensArray )	{
		$this->tmpContents = implode ( '', $fileContensArray );
		return true;
	}
	$this->errorMessage = "ƥץ졼ȥե뤬¸ߤޤ";
	return false;
}

/*	ʸ󤽤ΤΤƥץ졼Ȥꤹ롣
*/
function setTemplateAsString($str)	{
	$this->tmpContents = $str;
	return true;
}

/*	ƥץ졼Ȥ˰Ƥ򺹤ߡʸȤ롣¸ʸϾ񤭤롣
	ƥץ졼Ρ@@1@@פ$ar[0]ʸ֤롣
	ƥץ졼Ρ@@2@@פ$ar[1]ʸ֤롣Ȥäִ롣
	ȤСǤ5ξ硢@@6@@פ@@7@@פʤɤƥץ졼˻Ĥ뤬
	Ϻߤ򤷤Ƥ鶯Ū˺롣äˤfalse᤹
	Ǥ⺹߼ΤϹԤƤ롣
*/
function insertToTemplate($ar)	{
	$counter = 1;
	foreach ( $ar as $aItem )	{
		$this->tmpContents = str_replace( "@@$counter@@", $aItem, $this->tmpContents );
		$counter += 1;
	}
	if ( ! ereg( '@@[0-9]*@@', $tmpContents ) )	{
		$this->body = ereg_replace('@@[0-9]*@@', '', $this->tmpContents);
		$this->errorMessage = 'ߥƥץ졼Ȥ;ʬ֤ʸ@@@@ˤޤޤ';
		return false;
	}
	$this->body = $this->tmpContents;
	return true;
}

var $bodyWidth = 74;

/*	ʸμưԤΥХȿꤹ롣ͤ74ˤʤäƤ롣0ꤹȼưԤʤ	*/
function setBodyWidth($bytes)	{
	$this->bodyWidth = $bytes;
	return true;
}

function checkControlCodeNothing( $str )	{
	return ereg('[[:cntrl:]]', $str);
}

/*	᡼롣
	ToCcBccΥǡ˥ȥ륳ɤäƤȴʤΤǡξϥ顼
	ϤʤΤȤ롣
*/
function send()	{
	if ( $this->checkControlCodeNothing ( $this->toField ) )	{
		$this->errorMessage = 'ξ˥ȥ륳ɤޤޤƤޤ';
		return false;
	}
	if ( $this->checkControlCodeNothing ( $this->ccField ) )	{
		$this->errorMessage = 'ξ˥ȥ륳ɤޤޤƤޤ';
		return false;
	}
	if ( $this->checkControlCodeNothing ( $this->bccField ) )	{
		$this->errorMessage = 'ξ˥ȥ륳ɤޤޤƤޤ';
		return false;
	}
	$headerField = "X-Mailer: Open Mail Envrionment for PHP (http://mac-ome.jp/)\n";
	$headerField .= "Content-Type: text/plain; charset=ISO-2022-JP\n";
	if ( $this->fromField != '' )
		$headerField .= "From: $this->fromField\n";
	if ( $this->ccField != '' )
		$headerField .= "Cc: $this->ccField\n";
	if ( $this->bccField != '' )
		$headerField .= "Bcc: $this->bccField\n";
	if (  $this->extHeaders != '' )
		$headerField .= $this->extHeaders;

/*	$resultMail = mail(
		rtrim($this->header_base64_encode( $this->toField, False )),
		rtrim($this->header_base64_encode( $this->subject, true )),
		mb_convert_encoding( 
			$this->devideWithLimitingWidth( $this->body ), 'ISO-2022-JP' ),
		$this->header_base64_encode( $headerField, True ),
		$this->sendmailParam );
*/	$resultMail = mail(
		rtrim($this->header_base64_encode( $this->toField, False )),
		rtrim($this->header_base64_encode( $this->subject, False )),
		mb_convert_encoding( 
			$this->devideWithLimitingWidth( $this->body ), 'ISO-2022-JP' ),
		$this->header_base64_encode( $headerField, False ) );
	return $resultMail;
}

function devideWithLimitingWidth($str)    {
	if ( $this->bodyWidth == 0 )
		return $str;
	$newLine = "\n";
	$strLength = mb_strlen($str);
	$devidedStr = mb_substr( $str, $pos, 1 );
	$beforeChar = $devidedStr;
	if( $devidedStr == $newLine )
	    $byteLength = 0;
	else
	    $byteLength = strlen( $devidedStr );
	for( $pos = 1 ; $pos < $strLength ; $pos++){
	    $posChar = mb_substr( $str, $pos, 1 );
	    if( $posChar == $newLine )
	        $byteLength = 0;
	    else  {
	        if(        ( $byteLength >= $this->bodyWidth )
	               &&  ! $this->isInhibitLineTopChar( $posChar )
	               &&  ! $this->isInhibitLineEndChar( $beforeChar ) ) {
	    
	            if(        (    $this->isJapanese( $posChar )
	                         && ! $this->isSpace( $posChar )     )
	                    || (    $this->isJapanese( $beforeChar )
	                         && $this->isWordElement( $posChar ) )
	                    || (    ! $this->isWordElement( $beforeChar ) 
	                         && $this->isWordElement( $posChar ) ) ) {
	    
	                $devidedStr .= $newLine;
	                $byteLength = 0;
	            }       // Endo of if
	        }
	        $byteLength += strlen( $posChar );
	    }
	    $devidedStr .= $posChar ;
	    $beforeChar = $posChar;
	}
	return $devidedStr;
}    // End of function devideWithLimitingWidth()

function isSpace( $str )    {
	switch( $str )    {
	    case " ":
	    case "":    return True;
	}       // Endo of switch
	return False;
}    // End of isSpace()
	
function isWordElement( $str )    {
	if ( $this->isSpace( $str ) )    return False;
	$cCode = ord( $str );
	if ( ( $cCode >=0x30 ) && ($cCode <= 0x39) )    return True;
	if ( ( $cCode >=0x41 ) && ($cCode <= 0x5A) )    return True;
	if ( ( $cCode >=0x61 ) && ($cCode <= 0x7A) )    return True;
	switch( $str )    {
	    case "'":    return True;
	}       // Endo of switch
	return False;
}    // End of function isWordElement()

function isJapanese( $str )    {
	$cCode = ord( $str );
	if ( $cCode >=0x80 )    return True;
	return False;
}    // End of function isJapanese()

function isInhibitLineTopChar( $str )    {
	switch( $str )    {
	    case ')':    case ']':    case '}':     case '':    case '':
	    case '':   case '':   case '':    case '':    case '':
	    case '':   case '':   case '':    case "":    case '':
	    case ':':    case ';':    case '!':     case '.':     case '?': 
	    case '':   case '':   case '':    case '':    case '':
	    case '':   case '':   case '':    case '':    case '':
	        return True;
	}       // Endo of switch
	return False;
}    // End of function isInhibitLineTopChar

function isInhibitLineEndChar( $str )    {
	switch( $str )    {
	    case '(':     case '[':     case '{':     case '':    case '':
	    case '':    case '':    case '':    case '':    case '':
	    case '':    case '':    case '':    case "":
	        return True;
	}       // Endo of switch
	return False;
}    // End of function isInhibitLineEndChar

function header_base64_encode( $str, $isSeparateLine )    {
	$strLen = mb_strlen($str);
	$encodedString = '';
	$substring = '';
	$beforeIsMBChar = False;
	$isFirstLine = True;
	for ( $i = 0 ; $i <= $strLen ; $i++ )    {
	    if ( $i == $strLen )    
	        $thisIsMBChar = ! $beforeIsMBChar;
	    else    {
	        $ch = mb_substr($str, $i , 1);
	        $thisIsMBChar = ( ord($ch) > 127 );
	    }       // Endo of else
	    if (         ( $thisIsMBChar != $beforeIsMBChar ) 
	            &&   ( $substring != '' )    )    {
	        if ( $isSeparateLine && ( ! $isFirstLine ) )
	            $encodedString .= "\t";
	        if( $thisIsMBChar )      $encodedString .= $substring;
	        else      {
	            $jisSeq = mb_convert_encoding( $substring, 'ISO-2022-JP' );
	            $jisSeq .= chr(27) . '(B';
	            $bEncoded = base64_encode( $jisSeq );
	            $encodedString .= "=?ISO-2022-JP?B?$bEncoded?=";
	        }       // Endo of else
	        if ( $isSeparateLine )    $encodedString .= "\n";
	        $substring = '';
	        $isFirstLine = False;
	    }       // Endo of if
	    $substring .= $ch;
	    $beforeIsMBChar = $thisIsMBChar;
	}       // Endo of for
	return $encodedString;
}    // End of function header_base64_encode

}    // Endo of class OME

# history
# 2003/7/23 ֥᡼ƥκפΥץȤ
# 2003/9/13 OMEΥե꡼᡼Ѥ˾С󥢥å
# 2004/3/26 饹OMEȤƸˤ
# 2004/4/18 Хեå
# 2004/4/27 ХեåBccCcǤʤäΤ
?>
