<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:fmp="http://www.filemaker.com/fmpxmlresult" >
<xsl:output method="text" encoding="Shift_JIS" indent="yes" />

<!--
1:オンライン発注::id
2:オンライン発注::メールid
3:オンライン発注::日付
4:オンライン発注::名前
5:オンライン発注::会社名
6:オンライン発注::郵便番号
7:オンライン発注::住所
8:オンライン発注::電話番号
9:オンライン発注::メールアドレス
10:id
11:注文id
12:商品id
13:商品名copy
14:単価copy
15個数
16:金額
17:オンライン発注::合計金額
18:オンライン発注::消費税額
19:オンライン発注::請求金額
20:オンライン発注::アクセスコード
21:オンライン発注::発送状況
-->

<xsl:variable name="LF"><xsl:text>
</xsl:text></xsl:variable>

<xsl:template match="fmp:FMPXMLRESULT">
	<xsl:text>From: </xsl:text>
	<xsl:value-of select="concat( 'OMEオンラインショップ &lt;msyk@msyk.net&gt;', $LF)" />

	<xsl:text>To: </xsl:text>
	<xsl:value-of select="fmp:RESULTSET/fmp:ROW[1]/fmp:COL[9]/fmp:DATA" />
	<xsl:value-of select="$LF" />

	<xsl:text>Subject: </xsl:text>
	<xsl:value-of select="concat( 'ご注文内容の確認', $LF)" />

	<xsl:text>Bcc: </xsl:text>
	<xsl:value-of select="concat( 'msyk@msyk.net', $LF, $LF)" />

	<xsl:value-of select="fmp:RESULTSET/fmp:ROW[1]/fmp:COL[4]/fmp:DATA" />
	<xsl:value-of select="concat( '様', $LF, $LF)" />
	<xsl:text>ご注文内容の確認を依頼されました。ご指定されたご注文は以下の通りとなっています。</xsl:text>
	<xsl:value-of select="concat( $LF, $LF)" />

	<xsl:text>●ご注文日</xsl:text>
	<xsl:value-of select="fmp:RESULTSET/fmp:ROW[1]/fmp:COL[4]/fmp:DATA" />
	<xsl:value-of select="concat( $LF, $LF)" />

	<xsl:text>●発送状況</xsl:text>
	<xsl:value-of select="fmp:RESULTSET/fmp:ROW[1]/fmp:COL[21]/fmp:DATA" />
	<xsl:value-of select="concat( $LF, $LF)" />

	<xsl:text>●ご注文内容</xsl:text>
	<xsl:value-of select="$LF" />
	<xsl:for-each select="fmp:RESULTSET/fmp:ROW">
		<xsl:text>商品名：</xsl:text>
		<xsl:value-of select="fmp:COL[13]/fmp:DATA" />
		<xsl:value-of select="$LF" />
		<xsl:text>　単価：</xsl:text>
		<xsl:value-of select="fmp:COL[14]/fmp:DATA" />
		<xsl:text>円／個数：</xsl:text>
		<xsl:value-of select="fmp:COL[15]/fmp:DATA" />
		<xsl:text>／金額：</xsl:text>
		<xsl:value-of select="fmp:COL[16]/fmp:DATA" />
		<xsl:value-of select="concat('円', $LF)" />
	</xsl:for-each >
	<xsl:value-of select="$LF" />
	<xsl:text>合計金額：</xsl:text>
	<xsl:value-of select="fmp:RESULTSET/fmp:ROW[1]/fmp:COL[17]/fmp:DATA" />
	<xsl:value-of select="concat('円', $LF)" />
	<xsl:text>消費税額：</xsl:text>
	<xsl:value-of select="fmp:RESULTSET/fmp:ROW[1]/fmp:COL[18]/fmp:DATA" />
	<xsl:value-of select="concat('円', $LF)" />
	<xsl:text>請求金額：</xsl:text>
	<xsl:value-of select="fmp:RESULTSET/fmp:ROW[1]/fmp:COL[19]/fmp:DATA" />
	<xsl:value-of select="concat('円', $LF)" />
	<xsl:value-of select="$LF" />
	
	<xsl:text>●アクセスコード</xsl:text>
	<xsl:value-of select="$LF" />
	<xsl:value-of select="fmp:RESULTSET/fmp:ROW[1]/fmp:COL[20]/fmp:DATA" />
	<xsl:value-of select="concat($LF, $LF)" />

	<xsl:text>●お届け先</xsl:text>
	<xsl:value-of select="$LF" />
	<xsl:text>お名前：</xsl:text>
	<xsl:value-of select="fmp:RESULTSET/fmp:ROW[1]/fmp:COL[4]/fmp:DATA" />
	<xsl:value-of select="$LF" />
	<xsl:text>会社名（ご所属）：</xsl:text>
	<xsl:value-of select="fmp:RESULTSET/fmp:ROW[1]/fmp:COL[5]/fmp:DATA" />
	<xsl:value-of select="$LF" />
	<xsl:text>郵便番号：</xsl:text>
	<xsl:value-of select="fmp:RESULTSET/fmp:ROW[1]/fmp:COL[6]/fmp:DATA" />
	<xsl:value-of select="$LF" />
	<xsl:text>住所：</xsl:text>
	<xsl:value-of select="fmp:RESULTSET/fmp:ROW[1]/fmp:COL[7]/fmp:DATA" />
	<xsl:value-of select="$LF" />
	<xsl:text>電話番号：</xsl:text>
	<xsl:value-of select="fmp:RESULTSET/fmp:ROW[1]/fmp:COL[8]/fmp:DATA" />
	<xsl:value-of select="$LF" />
	<xsl:text>メールアドレス：</xsl:text>
	<xsl:value-of select="fmp:RESULTSET/fmp:ROW[1]/fmp:COL[9]/fmp:DATA" />
	<xsl:value-of select="$LF" />
</xsl:template>

</xsl:stylesheet>
