//
//  Scene1.m
//  OpenGLSample1
//
//  Created by Jun on 09/02/13.
//  Copyright 2009 有限会社ティックルハート. All rights reserved.
//

#import "Scene1.h"
#import <OpenGLES/EAGL.h>
#import <OpenGLES/ES1/gl.h>
#import <OpenGLES/ES1/glext.h>

static GLfloat mat_speculaer[] = { 1.0, 1.0, 1.0, 1.0 };
static GLfloat mat_shininess[] = { 50.0 };
static GLfloat light_position[] = { 1.0, 1.0, 1.0, 1.0 };
static GLfloat white_light[] =  { 1.0, 1.0, 0.0, 1.0 };
static GLfloat lmodel_ambient[] = { 0.1, 0.1, 0.1, 1.0 };

@implementation Scene1

-(void)prepareOpenGL
{
//	[shape prepareOpenGL];

	glShadeModel(GL_SMOOTH);
	glMaterialfv(GL_FRONT, GL_SPECULAR, mat_speculaer);
	glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
	glLightfv(GL_LIGHT0, GL_POSITION, light_position);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, white_light);
	glLightfv(GL_LIGHT0, GL_SPECULAR, white_light);
	glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lmodel_ambient);
}

-(void)cleanupOpenGL
{
}

-(void)drawOpenGL
{
	glEnable(GL_NORMALIZE);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glEnable(GL_COLOR_MATERIAL);
	
	
	[shape drawOpenGL];
	glDisable(GL_LIGHT0);
	glDisable(GL_LIGHTING);
}

@end
