//
//  StarShape.m
//  OpenGLSample1
//
//  Created by jun_at_server on 09/02/12.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "StarShape.h"

#define OUTER_RADIUS 1.0
#define INNER_RADIUS 0.38

#define ELEMENTS_OF_VERTEX 7
#define TIPS_OF_STAR_POINT 5
#define POINTS_OF_TRIANGLE 3
#define BOTH_SIDE 2
#define TRIANGLES_OF_POINT 2
#define DEPTH_OF_A_SIDE 0.25


// OpenGLの赤本から引用 バッファオブジェクトのオフセット用
#define BUFFER_OFFSET(bytes) ((GLubyte*) NULL + (bytes))


typedef struct Point4 {
	GLfloat x;
	GLfloat y;
	GLfloat z;
	GLfloat w;
} Point4;

typedef struct Point3 {
	GLfloat x;
	GLfloat y;
	GLfloat z;
} Point3;

Point4 StarVertex(int index, int countOfPoints, GLfloat innerRadius, GLfloat outerRadius)
{
	// 星形の頂点座標を算出
	Point4 result;
	GLfloat inverse,radius,angle;
	
	inverse = 1.0f / (countOfPoints * 2.0f);
	radius = (index % 2) ? innerRadius : outerRadius;
	angle = M_PI * index * 2.0f * inverse;
	
	result.x = -sinf( angle ) * radius;
	result.y = cosf( angle ) * radius;
	result.z = 0.0f;
	result.w = 1.0f;
	return result;
}

Point3 Point4ToPoint3(Point4 p)
{
	// Point4をPoint3に変換
	Point3 result;
	GLfloat inverse;
	
	inverse = 1.0f / p.w;
	result.x = p.x * inverse;
	result.y = p.y * inverse;
	result.z = p.z * inverse;
	return result;
}

Point3 Point3Sub(Point3 r,Point3 l)
{
	// Point3の引き算
	Point3 result;
	result.x = r.x - l.x;
	result.y = r.y - l.y;
	result.z = r.z - l.z;
	return result;
}

Point3 NormalVector(Point3 p0, Point3 p1, Point3 p2)
{
	// 三点からなる面の法線ベクトルを算出
	
	Point3 vec0,vec1,result;
	GLfloat length,inverse;
	
	vec0 = Point3Sub(p0, p1);
	vec1 = Point3Sub(p1, p2);
	
	result.x = vec0.y*vec1.z-vec1.y*vec0.z;
	result.y = vec0.x*vec1.z-vec1.x*vec0.z;
	result.z = vec0.x*vec1.y-vec1.x*vec0.y;
	
	length = sqrtf(powf(result.x, 2.0f) + powf(result.y, 2.0f) + powf(result.z, 2.0f));
	inverse = 1.0 / length;
	result.x *= inverse;
	result.y *= inverse;
	result.z *= inverse;
	
	return result;
}

@implementation StarShape

- (void) dealloc
{
	[self cleanupOpenGL];
	[super dealloc];
}


-(void)prepareOpenGL
{
	// 星形の立体形状の頂点座標と法線ベクトルを格納したバッファオブジェクトの生成
	
	Point4 p0,p1,c;
	Point3 norm;
	Point4 center[2] = { 0.0f, 0.0f,  DEPTH_OF_A_SIDE, 1.0f,
	                     0.0f, 0.0f, -DEPTH_OF_A_SIDE, 1.0f };
	GLfloat *temp;
	size_t baseOffset,aSizeOfTriangle,aSizeOfASide;
	int i,j;
	
	if (bufferObject != 0)
		return;
	
	aSizeOfTriangle = ELEMENTS_OF_VERTEX * POINTS_OF_TRIANGLE;
	aSizeOfASide    = aSizeOfTriangle * TIPS_OF_STAR_POINT * TRIANGLES_OF_POINT;
	temp            = malloc( sizeof(GLfloat) * aSizeOfASide * BOTH_SIDE);
	
	for( i = 0; i < BOTH_SIDE; i++)
	{
		c = center[i];
		for( j = 0; j < TIPS_OF_STAR_POINT * BOTH_SIDE; j++)
		{
			p0 = StarVertex( j    , TIPS_OF_STAR_POINT, INNER_RADIUS, OUTER_RADIUS);
			p1 = StarVertex( j + 1, TIPS_OF_STAR_POINT, INNER_RADIUS, OUTER_RADIUS);
			
			norm = i == 0 ? NormalVector(Point4ToPoint3(p0),Point4ToPoint3(p1),Point4ToPoint3(c))
			              : NormalVector(Point4ToPoint3(p1),Point4ToPoint3(p0),Point4ToPoint3(c));
			
			baseOffset = i * aSizeOfASide + j * aSizeOfTriangle;
			*( (Point4 *) ( temp + baseOffset     ) ) = p0;
			*( (Point3 *) ( temp + baseOffset + 4 ) ) = norm;
			*( (Point4 *) ( temp + baseOffset + 7 ) ) = p1;
			*( (Point3 *) ( temp + baseOffset + 11) ) = norm;
			*( (Point4 *) ( temp + baseOffset + 14) ) = c;
			*( (Point3 *) ( temp + baseOffset + 18) ) = norm;
		}
	}
	
	glGenBuffers(1, &bufferObject);
	glBindBuffer(GL_ARRAY_BUFFER, bufferObject);
	glBufferData(GL_ARRAY_BUFFER, sizeof(GLfloat) * aSizeOfASide * BOTH_SIDE, temp, GL_STATIC_DRAW);
	glBindBuffer(GL_ARRAY_BUFFER, 0);

	free(temp);
	
	glEnable(GL_NORMALIZE);
	glEnableClientState(GL_VERTEX_ARRAY);
    glEnableClientState(GL_NORMAL_ARRAY);
}

-(void)cleanupOpenGL
{
	// バッファオブジェクトの破棄
	
	if (bufferObject != 0)
		glDeleteBuffers(1, &bufferObject);
	
	// 動作身検証部分　（アプリケーション終了しても呼ばれないため）
}

-(void)drawOpenGL
{
	// バッファオブジェクトの描画
	
	glBindBuffer( GL_ARRAY_BUFFER, bufferObject );
	
	glVertexPointer(4, GL_FLOAT, ELEMENTS_OF_VERTEX * sizeof(GLfloat), BUFFER_OFFSET( 0 ) );
	glNormalPointer(GL_FLOAT, ELEMENTS_OF_VERTEX * sizeof(GLfloat), BUFFER_OFFSET( sizeof(GLfloat)*4 ) );
	
	glDrawArrays(GL_TRIANGLES, 0, POINTS_OF_TRIANGLE * TIPS_OF_STAR_POINT * TRIANGLES_OF_POINT * BOTH_SIDE );
	
	glBindBuffer(GL_ARRAY_BUFFER, 0);
}

@end

