//
//  StarsLayout4.m
//  OpenGLSample1
//
//  Created by jun_at_server on 09/02/15.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "StarsLayout2.h"

@implementation StarsLayout2

@synthesize shape;

- (void) dealloc
{
	[shape release];
	[super dealloc];
}

-(void)draw1
{
	// 元のテンプレートプロジェクトのEAGLView.mからコピーペーストしたコード
	// 一部追記してあります
	const GLfloat squareVertices[] = {
        -0.5f, -0.5f,
        0.5f,  -0.5f,
        -0.5f,  0.5f,
        0.5f,   0.5f,
    };
    const GLubyte squareColors[] = {
        255, 255,   0, 255,
        0,   255, 255, 255,
        0,     0,   0,   0,
        255,   0, 255, 255,
    };
    
	glDisable(GL_LIGHTING);
	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
    glRotatef(squareAngle, 0.0f, 0.0f, 1.0f);
	
	glVertexPointer(2, GL_FLOAT, 0, squareVertices);
	
    glColorPointer(4, GL_UNSIGNED_BYTE, 0, squareColors);
    glEnableClientState(GL_COLOR_ARRAY);
	
	glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
	
	glDisableClientState(GL_COLOR_ARRAY);
	
	glEnable(GL_LIGHTING);
}

-(void)draw2
{
	int i;
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	glScalef(0.1f, 0.1f, 0.1f);
	glRotatef(rotateAngle, 0.0f, 1.0f, 0.0f);
	glRotatef(rotateAngle2, 1.0f, 0.0f, 0.0f);
	
	glColor4f(1.0f, 1.0f, 0.0f, 1.0f);
	for(i = 0; i < 18; i++)
	{
		glRotatef(20.0f, 0.0f, 1.0f, 0.0f);
		glTranslatef(0.0f, 0.0f, 8.0f);
		[shape drawOpenGL];
		glTranslatef(0.0f, 0.0f, -8.0f);
	}
	
}

-(void)drawOpenGL
{
	squareAngle += 3.0f;
	if (squareAngle > 360.0f)
		squareAngle -= 360.0f;
	
	rotateAngle += 3.0f;
	if (rotateAngle > 360.0f)
		rotateAngle -= 360.0f;
	
	rotateAngle2 += 0.5f;
	if (rotateAngle > 360.0f)
		rotateAngle -= 360.0f;
	
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glFrustumf(-0.5f, 0.5f, -0.75f, 0.75f, 0.4f, 10.0f);
	glTranslatef(0.0f, 0.0f, -1.25f);
	
	[self draw1];
	[self draw2];
}

@end
