#import "AppController.h"

@implementation AppController

-(void)awakeFromNib	{

	//メニューバーやDockを表示ししないようにする
	// http://developer.apple.com/technotes/tn2002/tn2062.html
	OSStatus er = SetSystemUIMode( kUIModeAllHidden, 
		kUIOptionDisableAppleMenu |  kUIOptionDisableProcessSwitch |
		kUIOptionDisableForceQuit | kUIOptionDisableSessionTerminate );	
	if ( er != 0 )	NSLog(@"###Error in SetSystemUIMode.");

	//初期URLが設定されていない場合
	if ( [[baseURL stringValue] length] < 1 )
		[baseURL setStringValue:@"http://certifications.apple.com"];

	//メインスクリーンの解像度を取得
	NSRect screenSize = [[NSScreen mainScreen]frame];

	//ウインドウを全画面モードに再初期化
	[mainWindow setFrame:screenSize display:YES];

	[self loadFromServer];
}

- (void)loadFromServer	{

	NSString *url = [baseURL stringValue];
	[[webView mainFrame]loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:url]]];

	NSLog(@"###loadFromServer %@", url);
}

//ウインドウのタイトルバーの表示
- (void)webView:(WebView *)sender didFinishLoadForFrame:(WebFrame *)frame{

	[mainWindow setTitle:[webView mainFrameTitle]];
	NSLog(@"###didFinishLoadForFrame %@", [webView mainFrameTitle]);
}

//新規ウインドウのリクエストがあっても、新しいウインドウは表示せず、そのままロードする
- (WebView *)webView:(WebView *)sender createWebViewWithRequest:(NSURLRequest *)request
{
	[[webView mainFrame]loadRequest:request];
	return webView;
}

- (NSApplicationTerminateReply)applicationShouldTerminate:(NSApplication *)sender
{
	
	NSApplicationTerminateReply returnCode = NSTerminateCancel;
	
	NSAlert *alert = [NSAlert alertWithMessageText: NSLocalizedString(@"msg1", NULL) 
						defaultButton :NSLocalizedString(@"button1", NULL) 
						alternateButton: NSLocalizedString(@"button2", NULL) 
						otherButton: nil
						informativeTextWithFormat: NSLocalizedString(@"msg2", NULL)];
	[alert setAlertStyle:NSWarningAlertStyle];

	if ([alert runModal] == NSAlertAlternateReturn) {
		returnCode = NSTerminateNow;
	}

	NSLog(@"###applicationShouldTerminate: %d",returnCode);
	return returnCode;
}
@end
